using System;
using System.Collections.Specialized;
using System.Configuration;
using System.Windows.Forms;

using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.GUI.controls;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Provides a User Interface for a multidivisional user to choose which Division they are working for
	/// </summary>
	///<remarks>
	///<newpara> Package: VBECS - VistA Blood Establishment Computer System</newpara>
	///<newpara> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</newpara>
	///<newpara> Medical Device #: $MEDDEVICENO</newpara>
	///<newpara> Date Created: 4/30/2002</newpara>
	///<newpara> Site Name: Hines OIFO </newpara>
	///<newpara> Developers: Keith      lin</newpara>
	///<newpara> Note: The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</newpara>
	///</remarks>
	public class DlgSelectDivision: gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		/// <summary>
		/// This class represents single <see cref="Division"/> 
		/// item bound to <see cref="ListBox"/> control.
		/// </summary>
		private class DivisionListItem: ListViewItem
		{
			public readonly Division Division;

			public DivisionListItem(Division division)
				: base(division.DivisionName)
			{
				Division = division;
			}

			public string DisplayItem
			{
				get
				{
					return Division.DivisionName;
				}
			}
		}

		private VbecsButton btnOK;
		private VbecsButton btnCancel;
		private ListBox clstDivision;

		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		/// <summary>
		/// Constructor for dialog allowing selecting a <see cref="Division"/>
		/// </summary>
		/// <param name="allDivisions">List of divisions to display and choose from.</param>
		/// <param name="currentlySelectedDivision">
		///		Currently selected <see cref="Division"/> to mark in dialog.
		///	</param>
		public DlgSelectDivision(DivisionCollection allDivisions, Division currentlySelectedDivision)
			: base(false)
		{
			//this.btnCancel.Text = "&Cancel";
			if (allDivisions == null)
			{
				throw(new ArgumentNullException("allDivisions"));
			}

			InitializeComponent();

			vbecsLogo1.Title = "Select Division";
			RequiredFieldsLabel = false;
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC018.DlgSelectDivision());
			//
			SetTooltips();

			BindDivisionListBox(allDivisions, currentlySelectedDivision);

		}

		private void SetTooltips()
		{
			SetThisToolTip(clstDivision, StrRes.Tooltips.UC018.SelectDivisionclstDivisions());
			btnCancel.SetToolTip(StrRes.Tooltips.UC018.SelectDivisionbtnCancel().ResString);
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose(bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.clstDivision = new System.Windows.Forms.ListBox();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(298, 30);
			this.vbecsLogo1.Title = "Select Division";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 151);
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(136, 140);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 1;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgSelectDivision_KeyDownSpeakMessage);
			// 
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnCancel.Image = null;
			this.btnCancel.Location = new System.Drawing.Point(216, 140);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.Size = new System.Drawing.Size(75, 23);
			this.btnCancel.TabIndex = 4;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// clstDivision
			// 
			this.clstDivision.AccessibleDescription = "Select Division";
			this.clstDivision.AccessibleName = "Select Division";
			this.clstDivision.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.clstDivision.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.clstDivision.ItemHeight = 14;
			this.clstDivision.Location = new System.Drawing.Point(8, 36);
			this.clstDivision.Name = "clstDivision";
			this.clstDivision.Size = new System.Drawing.Size(284, 102);
			this.clstDivision.TabIndex = 3;
			this.clstDivision.DoubleClick += new System.EventHandler(this.clstDivision_DoubleClick);
			this.clstDivision.SelectedIndexChanged += new System.EventHandler(this.clstDivision_SelectedIndexChanged);
			// 
			// DlgSelectDivision
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(298, 167);
			this.ControlBox = false;
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.clstDivision);
			this.Controls.Add(this.btnOK);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.hlphelpChm.SetHelpKeyword(this, "Log_onto_VBECS_and_VistA.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "DlgSelectDivision";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "Select Division";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgSelectDivision_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.clstDivision, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.ResumeLayout(false);

		}

		#endregion

#if DEBUG 
		/// <summary>
		/// Visible Changed Event
		/// </summary>
		/// <param name="e"></param>
		protected override void OnVisibleChanged(EventArgs e)
		{
			base.OnVisibleChanged (e);

			NameValueCollection _configFileSettings = (NameValueCollection)System.Configuration.ConfigurationManager.GetSection( "DebugDivisionSelection" );

			// Check if config section exists
			if( _configFileSettings == null ) 
				return;			

			string _defaultDivisionCode = _configFileSettings[ Common.LogonUser.LogonUserName.ToUpper() ];

			if( _defaultDivisionCode == null )
				return;

			foreach( DivisionListItem _dli in clstDivision.Items )		
				if( _dli.Division.DivisionCode == _defaultDivisionCode )
				{
					clstDivision.SelectedItem = _dli;
					btnOK.PerformClick();
					break;
				}
		}

#endif

		/// <summary>
		/// Populates <see cref="ListBox"/> with the supplied list of divisions and 
		/// selects provided division in it. 
		/// </summary>
		/// <param name="allDivisions">Collection containing <see cref="Division"/> objects to populate <see cref="ListBox"/> with.</param>
		/// <param name="currentlySelectedDivision"><see cref="Division"/> to select in <see cref="ListBox"/>.</param>
		private void BindDivisionListBox(DivisionCollection allDivisions, Division currentlySelectedDivision)
		{
			clstDivision.DisplayMember = "DisplayItem";
			int nCount = 0;
			clstDivision.SuspendLayout();

			int _selectedDivisionItemIndex = -1;
			nCount = allDivisions.Count;
			for(int _divisionItemIndex = 0; _divisionItemIndex < nCount; _divisionItemIndex++)
			{
				Division _division = allDivisions[ _divisionItemIndex ];

				clstDivision.Items.Add(new DivisionListItem(_division));

				if (currentlySelectedDivision != null &&
					(_division == currentlySelectedDivision ||
						_division.DivisionCode.Trim() == currentlySelectedDivision.DivisionCode.Trim()))
				{
					_selectedDivisionItemIndex = _divisionItemIndex;
				}
			}

			clstDivision.SelectedIndex = _selectedDivisionItemIndex;

			UpdateButtonsAccordinglyToDivisionSelection();

			clstDivision.ResumeLayout();
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.OK;
		}

		private void clstDivision_DoubleClick(object sender, System.EventArgs e)
		{
			if (clstDivision.SelectedItems.Count > 0)
			{
				btnOK_Click(sender, e);
			}
		}

		private void UpdateButtonsAccordinglyToDivisionSelection()
		{
			if (clstDivision.SelectedItems.Count <= 0)
			{
				btnOK.SetToolTip(StrRes.Tooltips.UC018.SelectDivisionbtnOkDisabled().ResString);
				this.AcceptButton = null;
				btnOK.EnabledButton = false;
			}
			else
			{
				btnOK.SetToolTip(StrRes.Tooltips.UC018.SelectDivisionbtnOkEnabled().ResString);
				this.AcceptButton = btnOK;
				btnOK.EnabledButton = true;
			}
		}

		private void clstDivision_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			UpdateButtonsAccordinglyToDivisionSelection();
		}

		/// <summary>
		/// <see cref="Division"/> selected by user.
		/// </summary>
		public Division ChosenDivision
		{
			get
			{
				if (clstDivision.SelectedItems.Count > 0)
				{
					return ((DivisionListItem)clstDivision.SelectedItem).Division;
				}

				return null;
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgSelectDivision_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			string textToSpeak = "";

			if (this.btnOK.EnabledButton == false)
			{
				textToSpeak = this.btnOK.GetToolTip();
			}

			this.SpeakMessage( textToSpeak );		
		}

	}
}